# Babylonian (MUL.APIN)

## Introduction

<p>This <em>Babylonian sky culture</em>, which had been in use before the Greek one,
is preserved in a (probably almost) canonical state dating back to the 12th century BCE.
The earliest fragment known is from the 7th century BCE but the celestial data in the text
suggests a much earlier origin of the observational base - most likely between -1350 and -1150.</p>
<p><img width="800" src="illustrations/800px-MulApin-BritishMuseum.jpg"/></p>
<p><br/><i>photograph of one of the clay tablets that are as big as a sheet of paper (courtesy: the trustees of the British Museum)</i></p>

The compendium MUL.APIN consists of two large clay tablets with six and five lists of different content.
On the first tablet, there is the so called "star catalogue" (a list of names of stars and constellations),
followed by three lists of heliacal risings and settings, a list of ziqpu (culminating) asterisms,
and the list of constellations in the lunar path.
The second tablet contains intercalary rules for the calendar, rules for the sundial and rules for omina.

## Description

### Zodiac

<p>The zodiac definitely came to Greece from Babylonian source.
It is not preserved when it had been invented there and when it was transformed to Greek mathematical astronomy.
We know for sure that Hipparchus (2nd ct. BCE) cites ecliptical longitudes from Eudoxus (4th ct. BCE)
with a zodiac divided into 12x30 units, equaling our 360°. These direct citations from the 4th century BCE
suggest a much earlier invention because the concept of the zodiac of 360° was very likely well established
in Babylonian mathematical astronomy before it was copied by Greek mathematicians.
Taking Eudoxus' writing as a <em>terminus ante quem</em>, we extrapolate a date for the genesis of the zodiac in Mesopotamia before 400 BCE.
In other fragments of mathematical astronomy (between 800 and 700 BCE) the concept of the zodiac is not present.
Some scholars argue for the 6th century BCE as date of invention - but to be honest, we don't know.
The common sense is that the zodiac was probably invented around the middle of the 1st millennium BCE.</p>

In MUL.APIN, there is definitely no zodiac but a predecessor: the path of the Moon.
There are lists of constellations or "gods who stand in the path of the Moon,
through whose region the Moon during a month [passes repeatedly] and keeps touching them."
(cited from the edition by Hunger and Steele, 2018, p. 143).
This list of the MUL.APIN compendium is not considered in this sky culture; constellations in the path of the Moon are not highlighted.

### Planets

<p>This sky culture was made more or less only with the first list of the compendium, the so called `star catalogue'.
It is not a real star catalogue because it does not give a single coordinate and most of the names given there
are names of asterisms or constellations (and not point-like objects such as stars). The text of this first list is reproduced below - yet, we layouted it as a table to emphasis its function as an explanatory list. The catalogue also includes the names of planets: of course, planets do not have a fixed position.
However, in Mesopotamian culture it was common to mention them for a complete set of objects in the sky.
They are usually denoted (or drawn) at the position of their exaltation point (one of the later Greek <em>hypsomata</em> -
but Greek astrology provided two <em>hypsomata</em> per planet while Babylonian had only one).</p>

The names of the planets displayed in Stellarium are names of the objects in the sky and not of the gods associated with them.
The list below shows that almost every asterism was associated with a deity.
According to Babylonian belief, a deity has two representations: one in the sky and one on Earth as statue in the temple.
That means a celestial object `is' not the deity but only one of its possible expressions. This is also the case for the planets.
For instance, even a millennium before MUL.APIN, the goddess of sexual love and desire as well as goddess of war,
the Sumerian Inanna/ Akkadian Ishtar had been associated with the planet Venus.
This goddess was later `translated' to the Greek Aphrodite and Roman Venus and even in the Greco-Roman culture the name of the planet
was Phosphoros (Greek: the Luminous One) or Lucifer (Latin: the Bringer of Light) but associated with the goddess.
Similar cases exist for most of the constellations and single stars listed in MUL.APIN.

In the list reproduced below, the left column gives the name of the object in the sky and the right column (in most of the cases) gives the associated deity.

### Star Catalogue

The following table copies the reconstruction of the text of MUL.APIN by Hermann Hunger+ (1989, 2018),
gives translations by Manfred Krebernik (published at the Rencontre Assyriologique International, Innsbruck, 2018) and
identifies the Akkadian words with celestial regions and constellations (work by Susanne M. Hoffmann, 2015-2018, presented at Deutsche Orientalisten-Tagung, Jena, 2017).

<table cellpadding="7" cellspacing="1" style="background: transparent">
<tbody>
<tr valign="top" style="background: #e6e6e6; font-weight: bold">
<td width="5ex">constellation number</td>
<td>asterism to be "explained" (e.g. by relating it to a deity)</td>
<td>"explanation" (e.g. related deity)</td>
<td>position in the sky</td>
</tr>
<tr valign="top" style="background: #e7e6e6;">
<td><notr>1</notr></td>
<td><sup>STAR</sup><i>EPINNU</i>(Plough)</td>
<td><sup>GOD</sup>Enlil</td>
<td><notr>Cas</notr></td>
</tr>
<tr valign="top" style="background: #e7e6e6;">
<td><notr>2</notr></td>
<td><sup>STAR</sup><i>BARBARU</i>(Wolf)</td>
<td>seeder of <sup>STAR</sup><i>EPINNU</i></td>
<td><notr>&gamma; Cas and adjacent</notr></td>
</tr>
<tr valign="top" style="background: #dee6ef">
<td><notr>3</notr></td>
<td><sup>STAR</sup><i>&Scaron;&#298;BU</i>(Old Man)</td>
<td><sup>GOD</sup>Enme&scaron;arra</td>
<td><notr>Per</notr></td>
</tr>
<tr valign="top" style="background: #e7e6e6">
<td><notr>4</notr></td>
<td><sup>STAR</sup><i>GAMLU</i>(Throwing-stick)</td>
<td><sup>GOD</sup>Gamlum(Throwing-stick)</td>
<td>in <notr>Aur</notr></td>
</tr>
<tr valign="top" style="background: #dee6ef">
<td><notr>5</notr></td>
<td><sup>STAR</sup><i>T&#362;'AM&#362;&middot;RAB&Ucirc;TU</i>(Great Twins)</td>
<td><sup>GOD</sup>Lugalirra and <sup>GOD</sup>Meslamta&#702;ea</td>
<td><notr>Gem</notr></td>
</tr>
<tr valign="top" style="background: #e7e6e6">
<td><notr>6</notr></td>
<td><sup>STAR</sup><i>T&#362;'AM&#362;&middot;&#7778;E&#7722;R&#362;TU</i>(Little Twins)</td>
<td><sup>GOD</sup>Alammu&scaron; and <sup>GOD</sup>Ningublaga</td>
<td><notr>Gem</notr></td>
</tr>
<tr valign="top" style="background: #dee6ef">
<td><notr>7</notr></td>
<td><sup>STAR</sup><i>ALLUTTU</i>(Crab)</td>
<td>seat of <sup>GOD</sup>Anu</td>
<td><notr>Cnc</notr></td>
</tr>
<tr valign="top" style="background: #e7e6e6">
<td><notr>8</notr></td>
<td><sup>STAR</sup><i>URGUL&Ucirc;</i>(Lion)</td>
<td><sup>GOD</sup>Latarak</td>
<td><notr>Leo</notr></td>
</tr>
<tr valign="top" style="background: #e7e6e6">
<td><notr>9</notr></td>
<td>STAR opposite <sup>STAR</sup><i>URGUL&Ucirc;</i></td>
<td>STAR (of the) King</td>
<td>Regulus</td>
</tr>
<tr valign="top" style="background: #e7e6e6">
<td><notr>10</notr></td>
<td>twinkling STARs in the tail of <sup>STAR</sup><i>URGUL&Ucirc;</i></td>
<td>&quot;date-palm spadix&quot; (jewellery?) (of) <sup>GOD</sup>Erua, <sup>GOD</sup>Zarpan&#299;tum</td>
<td><notr>Com</notr></td>
</tr>
<tr valign="top" style="background: #dee6ef">
<td><notr>11</notr></td>
<td><sup>STAR</sup>&Scaron;U.PA(The Bright?)</td>
<td><sup>GOD</sup>Enlil who determines the destinies of the land</td>
<td><notr>Boo</notr></td>
</tr>
<tr valign="top" style="background: #dee6ef">
<td><notr>12</notr></td>
<td>STAR in front of it</td>
<td><sup>STAR</sup><i>&#7722;ENGALL&#256;YU</i>(Abundant), vizier of <sup>GOD</sup>Ninlil</td>
<td><notr>&alpha; Boo</notr> or <notr>&alpha; CVn</notr></td>
</tr>
<tr valign="top" style="background: #dee6ef">
<td><notr>13</notr></td>
<td>STAR behind it</td>
<td><sup>STAR</sup><i>B&#256;&Scaron;TUM</i>(Dignity), vizier of <sup>GOD</sup>Ti&scaron;pak</td>
<td><notr>CrB</notr></td>
</tr>
<tr valign="top" style="background: #e7e6e6">
<td><notr>14</notr></td>
<td><sup>STAR</sup><i>EREQQU</i>(Wagon)</td>
<td><sup>GOD</sup>Ninlil</td>
<td><notr>UMa</notr></td>
</tr>
<tr valign="top" style="background: #e7e6e6">
<td>15</td>
<td>STAR by the pole of <sup>STAR</sup><i>EREQQU</i></td>
<td><sup>STAR</sup><i>&Scaron;&#274;LEBU</i>(Fox), <sup>GOD</sup>Erra, the strong of the gods</td>
<td>Alcor (80 UMa) and north of it</td>
</tr>
<tr valign="top" style="background: #e7e6e6">
<td><notr>16</notr></td>
<td>STAR on the forehead of <sup>STAR</sup><i>EREQQU</i></td>
<td><sup>STAR</sup><i>LA&#7722;RU</i>(Ewe), <sup>GOD</sup>Aya</td>
<td><notr>west of &alpha; UMa </notr></td>
</tr>
<tr valign="top" style="background: #e7e6e6">
<td><notr>17</notr></td>
<td><sup>STAR</sup>MU.BU.K&Eacute;&Scaron;.DA (Hitched yoke?)</td>
<td><sup>GOD</sup><i>Anu-rab&ucirc;</i> of heaven</td>
<td><notr>reworked with the knowledge of [#5,#6,#7]</notr></td>
</tr>
<tr valign="top" style="background: #e7e6e6">
<td><notr>18</notr></td>
<td><sup>STAR</sup>MAR.G&Iacute;D.DA.AN.NA (Wagon of heaven)</td>
<td><sup>GOD</sup>Damkianna</td>
<td>UMi (according to Aratus)</td>
</tr>
<tr valign="top" style="background: #e7e6e6">
<td><notr>19</notr></td>
<td>STAR in its bond</td>
<td><sup>STAR</sup><i>APIL-EMA&#7722;</i> (Heir of the Ema&#7723;-temple), foremost son of <sup>GOD</sup>Anu</td>
<td><notr>somewhere in the circumpolar area</notr></td>
</tr>
<tr valign="top" style="background: #c6c6c6; color: #ff0000">
<td></td>
<td colspan="3">The stars (of the) Standing Gods of the Ekur temple</td>
</tr>
<tr valign="top" style="background: #c6c6c6; color: #ff0000">
<td></td>
<td colspan="3">The stars (of the) Sitting Gods of the Ekur temple</td>
</tr>
<tr valign="top" style="background: #e7e6e6">
<td><notr>20</notr></td>
<td><sup>STAR</sup><i>ENZU</i>(She-Goat)</td>
<td><sup>GOD</sup>Gula</td>
<td><notr>Lyr</notr></td>
</tr>
<tr valign="top" style="background: #e7e6e6">
<td><notr>21</notr></td>
<td>STAR in front of <sup>STAR</sup><i>ENZU</i></td>
<td><sup>STAR</sup><i>KALBU</i>(Dog) (of <sup>GOD</sup>Gula)</td>
<td>in <notr>Her</notr></td>
</tr>
<tr valign="top" style="background: #e7e6e6">
<td><notr>22</notr></td>
<td>bright STAR of <sup>STAR</sup><i>ENZU</i></td>
<td><sup>GOD</sup>Lamassatu, vizier of <sup>GOD</sup>Baba (= <sup>GOD</sup>Gu-la)</td>
<td><notr>&alpha; Lyr</notr></td>
</tr>
<tr valign="top" style="background: #e7e6e6">
<td><notr>23</notr></td>
<td>2 STAR<sup>s</sup> behind it</td>
<td><sup>GOD</sup>Nin-SAR and <sup>GOD</sup>Errakal</td>
<td><notr>&eta;, &theta; Lyr ?</notr></td>
</tr>
<tr valign="top" style="background: #dee6ef">
<td><notr>24</notr></td>
<td><sup>STAR</sup>U<sub>4</sub>.KA.DU<sub>8</sub>.A</td>
<td><sup>GOD</sup>U.GUR(Nergal)</td>
<td><notr>Cyg</notr></td>
</tr>
<tr valign="top" style="background: #dee6ef">
<td><notr>25</notr></td>
<td>STAR to the right of it</td>
<td><sup>STAR</sup>&Scaron;<i>A&#7722;&Ucirc;</i>(Pig), <sup>GOD</sup>Damu</td>
<td><notr>?</notr></td>
</tr>
<tr valign="top" style="background: #dee6ef">
<td><notr>26</notr></td>
<td>STAR to the left of it</td>
<td><sup>STARS</sup><i>SIS&Ucirc;</i>(Horse)</td>
<td><notr>?</notr></td>
</tr>
<tr valign="top" style="background: #dee6ef">
<td><notr>27</notr></td>
<td>STAR behind it</td>
<td><sup>STAR</sup><i>LULIMMU</i>, vizier of STAR.STAR (Pleiades)</td>
<td><notr>?</notr></td>
</tr>
<tr valign="top" style="background: #dee6ef">
<td><notr>28</notr></td>
<td>twinkling STAR<sup>s</sup> opposite <sup>STAR</sup><i>LULIMMU</i>(Stag)</td>
<td><sup>GOD</sup>&#7722;arriru (Field Mouse), <sup>GOD</sup>Manz&acirc;t(Rainbow)</td>
<td><notr>M31 ?</notr></td>
</tr>
<tr valign="top" style="background: #dee6ef">
<td><notr>29</notr></td>
<td>red bright STAR in the kidney of <sup>STAR</sup><i>LULIMMU</i></td>
<td><sup>STAR</sup><i>P&#256;&Scaron;ITTU</i>(Deleter)</td>
<td><notr>??? (unknown)</notr></td>
</tr>
<tr valign="top" style="background: #c6c6c6; color: #ff0000">
<td></td>
<td colspan="3">When the STAR<sup>s</sup> of <sup>GOD</sup>Enlil are completed:</td>
</tr>
<tr valign="top" style="background: #e7e6e6">
<td><notr>30</notr></td>
<td>big STAR, its &quot;light&quot; is dim, it divides the sky and stands</td>
<td style="color: #0070c0">STAR (of) <sup>GOD</sup>Marduk, <sup>GOD</sup>N&#275;beru(Ford)</td>
<td>Milky Way???</td>
</tr>
<tr valign="top" style="background: #e6e6e6; color: #0070c0">
<td><notr>31</notr></td>
<td colspan="2"><sup>STAR</sup>SAG.ME.GAR(Jupiter), it changes its place and crosses the sky</td>
<td>Jupiter [hypsoma]</td>
</tr>
<tr valign="top" style="background: #c6c6c6; color: #ff0000">
<td></td>
<td colspan="3">33 STAR<sup>s</sup> of <sup>GOD</sup>Enlil</td>
</tr>
</tbody>
</table>
<p><b>Remark 1</b>: <i>Babylonian lists do not have headlines but a sort of caption. Lines written in red [by us] indicate this line to be such a footer which summarizes the text before as a sort of (sub)section or chapter. The planets, we highlighted in blue.</i></p>
<p><b>Remark 2</b>: <i>At this line, the text tells us that there were 33 asterism listed before this line. However, on the original clay tablet(s) there had been only 31 lines. Therefore, the counting of asterisms for the authors of MUL.APIN is an often discussed topic in this context. There are several different suggestions and we have even made an own one but since all versions are uncertain, we are not brave enough to publish any of them here. We are not sure, if there is any common sense about that in the scientific community.</i></p>
<table cellpadding="7" cellspacing="1">
<tbody>
<tr valign="top" style="background: #e6e6e6; font-weight: bold">
<td width="5ex">constellation number</td>
<td>asterism to be "explained" (e.g. by relating it to a deity)</td>
<td>"explanation" (e.g. related deity)</td>
<td>position in the sky</td>
</tr>
<tr valign="top" style="background: #e7e6e6">
<td><notr>32</notr></td>
<td><sup>STAR</sup>ONE&middot;&quot;FIELD&quot;(area measure)</td>
<td>seat of <sup>GOD</sup>Ea who goes in front of the STAR<sup>s</sup> of <sup>GOD</sup>Anu</td>
<td><notr>Peg</notr></td>
</tr>
<tr valign="top" style="background: #e7e6e6">
<td><notr>33</notr></td>
<td>STAR opposite <sup>STAR</sup>ONE&middot;'FIELD'</td>
<td><sup>STAR</sup><i>&Scaron;IN&#362;NUTU</i>(Swallow)</td>
<td><notr>Psc</notr></td>
</tr>
<tr valign="top" style="background: #e7e6e6">
<td><notr>34</notr></td>
<td>STAR behind <sup>STAR</sup>ONE&middot;'FIELD'</td>
<td><sup>STAR</sup><i>ANUNN&#298;TU</i></td>
<td><notr>Psc</notr></td>
</tr>
<tr valign="top" style="background: #e7e6e6">
<td><notr>35</notr></td>
<td>STAR behind it</td>
<td><sup>STAR</sup><i>AGRU</i>(Hired Worker), <sup>GOD</sup>Tammuz</td>
<td><notr>Ari</notr></td>
</tr>
<tr valign="top" style="background: #dee6ef">
<td><notr>36</notr></td>
<td>STAR.STAR(<i>ZAPPU</i>, Bristle)</td>
<td><sup>GOD</sup>Sebettu, the great gods</td>
<td>Pleiades</td>
</tr>
<tr valign="top" style="background: #e7e6e6">
<td><notr>37</notr></td>
<td><sup>STAR</sup>BULL&middot;OF&middot;HEAVEN(<i>AL&Ucirc;</i>)</td>
<td><sup>GOD</sup><i>Is-l&ecirc;</i> (Jaw of the Wild Bull), crown of <sup>GOD</sup>Anu</td>
<td><notr>Tau</notr></td>
</tr>
<tr valign="top" style="background: #dee6ef">
<td><notr>38</notr></td>
<td><sup>STAR</sup>TRUE&middot;SHEPHERD&middot;OF&middot;HEAVEN (<i>&Scaron;ITADDALLU</i>, Orion)</td>
<td><sup>GOD</sup>Papsukkal, vizier of <sup>GOD</sup>Anu</td>
<td><notr>Ori</notr></td>
</tr>
<tr valign="top" style="background: #dee6ef">
<td><notr>39</notr></td>
<td>Twin STARs opposite <sup>STAR</sup><i>&Scaron;ITADDALLU</i></td>
<td><sup>GOD</sup>Lulal and <sup>GOD</sup>Latarak</td>
<td><notr>&pi;<sub>3</sub>, &pi;<sub>4</sub> Ori ?</notr></td>
</tr>
<tr valign="top" style="background: #dee6ef">
<td><notr>40</notr></td>
<td>STAR behind it</td>
<td><sup>STAR</sup><i>TARLUGALLU</i> (Cock)</td>
<td><notr>Lep (</notr>or<notr> &alpha; CMi ??)</notr></td>
</tr>
<tr valign="top" style="background: #e7e6e6">
<td><notr>41</notr></td>
<td><sup>STAR</sup>GAG.SI.S&Aacute;(Arrow)</td>
<td><i>&Scaron;ilt&#257;&#7723;u</i> (Arrow), great hero (of) <sup>GOD</sup>Ninurta</td>
<td>Sirius + </td>
</tr>
<tr valign="top" style="background: #dee6ef">
<td><notr>42</notr></td>
<td><sup>STAR</sup><i>QA&Scaron;TU</i>(Bow)</td>
<td><sup>GOD</sup>I&scaron;tar-of-Elam, daughter of <sup>GOD</sup>Enlil</td>
<td>in <notr>CMa ?</notr></td>
</tr>
<tr valign="top" style="background: #e7e6e6">
<td><notr>43</notr></td>
<td>STAR (of) <sup>GOD</sup>NIRA&#7722;(Snake-god)</td>
<td><sup>GOD</sup>Ningi&scaron;zida, lord of the 'Earth' (= netherworld)</td>
<td><notr>Hya</notr></td>
</tr>
<tr valign="top" style="background: #dee6ef">
<td><notr>44</notr></td>
<td><sup>STAR</sup><i>&#256;RIBU</i>(Raven)</td>
<td>Raven, STAR of <sup>GOD</sup>Adad</td>
<td><notr>Crv</notr></td>
</tr>
<tr valign="top" style="background: #e7e6e6">
<td><notr>45</notr></td>
<td><sup>STAR</sup><i>&Scaron;ER&#702;U</i>(Furrow)</td>
<td><sup>GOD</sup>&Scaron;ala, ear of grain</td>
<td><notr>Vir</notr></td>
</tr>
<tr valign="top" style="background: #dee6ef">
<td><notr>46</notr></td>
<td><sup>STAR</sup><i>ZIB&#256;N&#298;TU</i>(Scales)</td>
<td>Horns of <sup>STAR</sup><i>ZUQAQ&#298;PU</i>(Scorpion)</td>
<td>circa Lib</td>
</tr>
<tr valign="top" style="background: #e7e6e6">
<td><notr>47, 48, 49</notr></td>
<td>STAR (of) <sup>GOD</sup>Zababa</td>
<td><sup>STAR</sup><i>ER&Ucirc;</i>(Eagle) and <sup>STAR</sup><i>PAGRU</i>(Corpse)</td>
<td><notr>Oph, Aql+</notr></td>
</tr>
<tr valign="top" style="background: #e6e6e6; color: #0070c0">
<td><notr>50</notr></td>
<td colspan="2"><sup>STAR</sup><i>DILPAT</i>(Venus), it changes its place and crosses the sky</td>
<td>Venus</td>
</tr>
<tr valign="top" style="background: #e6e6e6; color: #0070c0">
<td><notr>51</notr></td>
<td colspan="2"><sup>STAR</sup><i>&#7778;ALBAT&#256;NU</i>(Mars), it changes its place and crosses the sky</td>
<td>Mars</td>
</tr>
<tr valign="top" style="background: #e6e6e6; color: #0070c0">
<td><notr>52</notr></td>
<td colspan="2"><sup>STAR</sup>STEADY&middot;&quot;WILD&middot;SHEEP&quot;(<i>KAJJAM&#256;NU</i>, Saturn), it changes its place and crosses the sky</td>
<td>Saturn</td>
</tr>
<tr valign="top" style="background: #e6e6e6; color: #0070c0">
<td><notr>53</notr></td>
<td colspan="2"><sup>STAR</sup>DANCING&middot;&quot;WILD&middot;SHEEP&quot;(<i>&Scaron;I&#7722;&#7788;U</i>, Mercury),
whose name is <sup>GOD</sup>Ninurta, either in the East or in the West, where ever in the month it appears, where ever in the month it disappears</td>
<td>Mercury</td>
</tr>
<tr valign="top" style="background: #c6c6c6; color: #ff0000">
<td></td>
<td colspan="3">23 STAR<sup>s</sup> of Anum</td>
</tr>
</tbody>
</table>
<p><b>Remark 3:</b> <i>Giving a "+" sign in the column of the modern counterpart, we indicate that (likely/ possibly) more stars are belonging to this Babylonian asterism. In case of the Arrow, for instance, it is sure that Sirius belongs to this constellation but modern authors published at least three versions which further stars have to be added. Another case is the Eagle next to another constellation named "the Corpse". This could possibly be a predecessor of Ptolemy's newly added double-constellation "Eagle with Antinuos" but it can also be independent - that is why, we give "Aql+".</i></p>
<table cellpadding="7" cellspacing="1">
<tbody>
<tr valign="top" style="background: #e6e6e6; font-weight: bold">
<td width="5ex">constellation number</td>
<td>asterism to be "explained" (e.g. by relating it to a deity)</td>
<td>"explanation" (e.g. related deity)</td>
<td>position in the sky</td>
</tr>
<tr valign="top" style="background: #e7e6e6">
<td><notr>54</notr></td>
<td><sup>STAR</sup><i>N&#362;NU</i>(Fish)</td>
<td><sup>GOD</sup>Ea who goes in front of the STAR<sup>s</sup> of <sup>GOD</sup>Ea</td>
<td><notr>PsA</notr></td>
</tr>
<tr valign="top" style="background: #dee6ef">
<td><notr>55</notr></td>
<td>GREAT&middot;STAR</td>
<td><sup>GOD</sup>Ea</td>
<td><notr>Aqr</notr></td>
</tr>
<tr valign="top" style="background: #dee6ef">
<td><notr>56</notr></td>
<td>STAR of (the city of) Eridu</td>
<td> <sup>GOD</sup>Ea </td>
<td>Canopus<notr> (&alpha; Car)</notr></td>
</tr>
<tr valign="top" style="background: #dee6ef">
<td><notr>57</notr></td>
<td>STAR to its right</td>
<td>STAR (of) <sup>&lt;GOD&gt;</sup>Ninma&#7723;</td>
<td><notr>?</notr></td>
</tr>
<tr valign="top" style="background: #e7e6e6">
<td><notr>58</notr></td>
<td><sup>STAR</sup><i>&#7722;AB(B)A&#7778;&#7778;&#274;R&#256;NU</i></td>
<td><sup>GOD</sup>Ningirsu</td>
<td><notr>?</notr></td>
</tr>
<tr valign="top" style="background: #e7e6e6">
<td><notr>59</notr></td>
<td>STAR to its right</td>
<td><sup>STAR</sup><i>MA&Scaron;KAK&#256;TU</i>(Harrow), weapon of <sup>GOD</sup>M&#257;r-b&#299;ti, in the centre of which the Aps&ucirc; is visible</td>
<td>in <notr>Vela (Aps&ucirc;~MW?)</notr></td>
</tr>
<tr valign="top" style="background: #e7e6e6">
<td><notr>60</notr></td>
<td>2 STAR<sup>s</sup> behind it</td>
<td><sup>GOD</sup>&Scaron;ullat and <sup>GOD</sup>&#7722;ani&scaron;, <sup>GOD</sup>&Scaron;ama&scaron; and <sup>GOD</sup>Adad</td>
<td><notr>?</notr></td>
</tr>
<tr valign="top" style="background: #e7e6e6">
<td><notr>61</notr></td>
<td>STAR behind it which lights up like <sup>GOD</sup>Ea (and) sets like Ea</td>
<td>STAR (of) <sup>GOD</sup>Numu&scaron;da, <sup>GOD</sup>Adad</td>
<td><notr>Cen</notr></td>
</tr>
<tr valign="top" style="background: #dee6ef">
<td><notr>62</notr></td>
<td>STAR to the left of <sup>STAR</sup><i>ZUQAQ&#298;PU</i>(Scorpion)</td>
<td><sup>STAR</sup><i>URIDIMMU</i> = <sup>GOD</sup>Kusu</td>
<td><notr>Lup</notr></td>
</tr>
<tr valign="top" style="background: #dee6ef">
<td><notr>63</notr></td>
<td><sup>STAR</sup><i>ZUQAQ&#298;PU</i></td>
<td><sup>GOD</sup>I&scaron;&#7723;ara, lady of the inhabited world</td>
<td><notr>Sco</notr></td>
</tr>
<tr valign="top" style="background: #dee6ef">
<td><notr>64</notr></td>
<td><sup>STAR</sup><i>IRAT&middot;ZUQAQ&#298;PI<br/></i>(Breast of the Scorpion)</td>
<td><sup>GOD</sup>Lisin, <sup>GOD</sup>Nab&ucirc;</td>
<td>Antares<notr> (&alpha; Sco)</notr></td>
</tr>
<tr valign="top" style="background: #dee6ef">
<td><notr>65</notr></td>
<td>2 STAR<sup>s</sup> on the sting (<i>ZIQTU</i>) of <sup>STAR</sup><i>ZUQAQ&#298;PU</i></td>
<td><sup>GOD</sup>&Scaron;arur and <sup>GOD</sup>&Scaron;argaz</td>
<td><notr>&lambda;, &nu; Sco</notr></td>
</tr>
<tr valign="top" style="background: #dee6ef">
<td><notr>66</notr></td>
<td>STAR behind them</td>
<td><sup>GOD</sup>Pabilsa&#285;</td>
<td><notr>Sgr</notr></td>
</tr>
<tr valign="top" style="background: #e7e6e6">
<td><notr>67, 68</notr></td>
<td><sup>STAR</sup><i>MAKURRU</i>(Bark) &lt;&lt;and&gt;&gt; </td>
<td><sup>STAR</sup><i>SU&#7722;URM&#256;&Scaron;U</i>(Goat-fish)</td>
<td><notr>(CrA &amp;) Cap</notr></td>
</tr>
<tr valign="top" style="background: #c6c6c6;; color: #ff0000">
<td></td>
<td colspan="3">15 STAR<sup>s</sup> of <sup>GOD</sup>Ea</td>
</tr>
</tbody>
</table>

### Source(s)

The stick figures are interpretations by Susanne M. Hoffmann based on some years of her doctoral and post-doctoral research.
In some cases they deviate from the common identifications copied by Pingree, Hunger and other scholars since 1950 or earlier.
Hunger's new edition of MUL.APIN (2018) allowed new insights. Some of the figures have been derived in Hoffmann's dissertation thesis
(in the chapters on the Babylonian roots of the Greek culture: Hipparchs Himmelsglobus, Springer, 2017) and some others were developed
during her work as director of the planetarium Königsleiten together with other, mainly German, planetariums.
A first scientific article on visualization of two versions of the Babylonian zodiac appeared in:
Wolfschmidt, Gudrun [ed.]: Popularisierung der Astronomie, Nuncius Hamburgensis, Hamburg, 2017.
Further publications are in preparation (e.g. together with M. Krebernik for the proceedings of the Rencontre Assyriologique Internationale 2018). See chapter "Further Reading" below.

## References

 - [#1]: British Museum [Image Tablet No 152339001](https://www.britishmuseum.org/collection/image/152339001)
 - [#2]: Hermann Hunger and John Steele, The Babylonian astronomical compendium MUL.APIN, Routledge, London/New York 2018.
 - [#3]: Susanne M. Hoffmann: [Hipparchs Himmelsglobus](https://www.springer.com/de/book/9783658186821), Springer, Wiesbaden, New York, 2017.
 - [#4]: Susanne M. Hoffmann: *History of Constellations as popularization of uranometry* in: Wolfschmidt, Gudrun [ed.]: [Popularisierung der Astronomie](https://tredition.de/autoren/gudrun-wolfschmidt-1029/popularisierung-der-astronomie-proceedings-der-tagung-des-arbeitskreises-astronomiegeschichte-in-der-astronomischen-gesellschaft-in-bochum-2016-hardcover-91756/), Nuncius Hamburgensis, Bd. 41, Hamburg, 2017.
 - [#5]: Hoffmann, S.M. and Krebernik, M. (2023): *What do deities tell us about the celestial positioning system*, in: R. Rollinger, I. Madreiter, M. Lang, C. Pappi (eds.). The Intellectual Heritage of the Ancient Near East, Papers held at the 64th Rencontre Assyriologique International and 12th Melammu Symposium July 16-20 2018, Innsbruck. Austrian Academy of Sciences Press, 539-579
 - [#6]: Hoffmann and Horowitz (2023). The Standing and Sitting Asterisms of Ekur, N.A.B.U., n°3 (sept.), 141-143
 - [#7]: Hoffmann, S.M. (2024). Standing and Sitting Gods of MUL.APIN, Journal of Astronomical History and Heritage, 27(2), 261-272 

### Fair Use

This sky culture originates from many years of research by several scholars. We provide this for free but authors of contributions certainly deserve to be cited according to the common rules. Thank you!

### Thanks to

The positioning of the Babylonian terms in the sky and the drawing of the stick figures for Stellarium had been done by Susanne M. Hoffmann.
As an astronomer she thanks for the help of several philologists and the some very enthusiastic planetarium managers for some developments in their domes.

 - Prof. i.R. Dr. Hermann Hunger (Assyriology, Vienna)
 - Prof. Dr. Manfred Krebernik (Assyriology, Jena)
 - Dr. Björn Voss (Manager of LWL Planetarium Münster and head of Society of German-speaking Planetariums)
 - Dr. Monika Staesche (Manager of Planetarium am Insulaner, Berlin)
 - Stefan Harnisch (Manager of Planetarium Jena)

## Authors

The Babylonian star names and constellation lines were compiled and added to Stellarium:

<p><em>Susanne M. Hoffmann:   service@uhura-uraniae.com </em></p>
<p>Paintings by: <em>Jessica Gullberg </em> (consulted by Steven Gullberg and Susanne M Hoffmann)</p>
<p>Text in English: <em>Susanne M. Hoffmann</em></p>

## License

CC BY-ND 4.0
